/*
 * Decompiled with CFR 0.152.
 */
package net.sabicorp.modsupdater;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModsUpdater {
    private static final String API_BASE = "https://mcupdater.sabicorp.net/";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void main(String[] args) {
        ModpackDefinition modpack;
        String env;
        File modsDir;
        String instMcDir;
        System.out.println("=== SABICORP ModsUpdater ===");
        String modpackId = ModsUpdater.getModpackIdFromArgs(args);
        if (modpackId == null) {
            System.err.println("[ERROR] No se ha proporcionado --modpackid=...");
            System.exit(1);
        }
        if ((instMcDir = System.getenv("INST_MC_DIR")) == null || instMcDir.isEmpty()) {
            System.err.println("[ERROR] No se ha definido la variable de entorno INST_MC_DIR.");
            System.exit(1);
        }
        if (!(modsDir = new File(instMcDir, "mods")).exists()) {
            System.err.println("[ERROR] La carpeta de mods no existe: " + modsDir.getAbsolutePath());
            System.exit(1);
        }
        String jsonFilename = ((env = ModsUpdater.getEnvFromArgs(args)) != null ? env : "latest") + ".json";
        String jsonUrl = API_BASE + modpackId + "/" + jsonFilename;
        System.out.println("[DOWNLOAD] Cargando datos desde: " + jsonUrl);
        try (InputStream in = new URL(jsonUrl).openStream();){
            modpack = (ModpackDefinition)gson.fromJson((Reader)new InputStreamReader(in), ModpackDefinition.class);
        }
        catch (IOException e) {
            System.err.println("[ERROR] No se pudo descargar la definici\u00f3n del modpack: " + e.getMessage());
            return;
        }
        List<ModInfo> mods = modpack.mods;
        List<ConfigEdit> configEdits = modpack.config;
        SelfUpdater updater = modpack.selfUpdater;
        System.out.println("--- Comprobando self updater version ---");
        if (updater != null) {
            try {
                File currentJar = new File(ModsUpdater.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                String currentName = currentJar.getName();
                if (currentName.equals(updater.target)) {
                    System.out.println("[OK] Usando la \u00faltima versi\u00f3n del updater: " + updater.target);
                } else {
                    System.out.println("[NEW] Nueva versi\u00f3n del updater disponible: " + updater.target);
                    File targetFile = new File(currentJar.getParentFile(), updater.target);
                    if (!targetFile.exists()) {
                        System.out.println("[DOWNLOAD] Descargando updater desde: " + updater.url);
                        try (InputStream inputStream = new URL(updater.url).openStream();){
                            Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            System.out.println("[OK] Guardado: " + updater.target);
                        }
                    }
                    Path path = Paths.get(instMcDir, new String[0]).getParent().resolve("instance.cfg");
                    List<String> lines = Files.readAllLines(path);
                    ArrayList<Object> updated = new ArrayList<Object>();
                    for (String string : lines) {
                        if (string.startsWith("PreLaunchCommand=")) {
                            String newCmd = "PreLaunchCommand=java -jar " + updater.target + " --modpackid=" + modpackId;
                            if (env != null) {
                                newCmd = newCmd + " --env=" + env;
                            }
                            updated.add(newCmd);
                            System.out.println("[OK] Actualizado instance.cfg con nueva versi\u00f3n");
                            continue;
                        }
                        updated.add(string);
                    }
                    Files.write(path, updated, new OpenOption[0]);
                    System.out.println("[IMPORTANT] Los cambios se aplicar\u00e1n al reiniciar MultiMC.");
                }
                File[] allFiles = currentJar.getParentFile().listFiles();
                if (allFiles != null) {
                    for (File f : allFiles) {
                        if (!f.getName().startsWith("sabicorp-mods-updater-") || !f.getName().endsWith(".jar") || f.getName().equals(currentName) || f.getName().equals(updater.target) || !f.delete()) continue;
                        System.out.println("[DELETED] Eliminado updater viejo: " + f.getName());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("[ERROR] Error al actualizar el updater: " + e.getMessage());
            }
        }
        System.out.println("--- Comprobando mods instalados ---");
        for (ModInfo mod : mods) {
            Pattern pattern = Pattern.compile(mod.pattern);
            File file = new File(modsDir, mod.target);
            if (file.exists()) {
                System.out.println("[OK] Ya actualizado: " + mod.target);
                continue;
            }
            for (File file2 : Objects.requireNonNull(modsDir.listFiles())) {
                if (!pattern.matcher(file2.getName()).matches() || file2.getName().equals(mod.target)) continue;
                System.out.println("[DELETE] Eliminando: " + file2.getName());
                file2.delete();
            }
            System.out.println("[DOWNLOAD] Descargando " + mod.name + " desde " + mod.url);
            try {
                InputStream in = new URL(mod.url).openStream();
                try {
                    Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("[OK] Mod actualizado: " + mod.target);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                System.err.println("[ERROR] Error descargando " + mod.name + ": " + e.getMessage());
            }
        }
        System.out.println("--- Comprobando configuraci\u00f3n ---");
        for (ConfigEdit config : configEdits) {
            File configFile = new File(instMcDir, config.file);
            if (!configFile.exists()) {
                System.out.println("[SKIP] Archivo no encontrado, se ignora: " + config.file);
                continue;
            }
            if (configFile.getName().toLowerCase().endsWith(".json")) {
                try (FileReader fileReader = new FileReader(configFile);){
                    JsonObject json = (JsonObject)gson.fromJson((Reader)fileReader, JsonObject.class);
                    boolean modified = false;
                    for (Map.Entry entry : config.replacements.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        JsonElement current = json.get(key);
                        JsonPrimitive newVal = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") ? new JsonPrimitive(Boolean.valueOf(Boolean.parseBoolean(value))) : (value.matches("-?\\d+(\\.\\d+)?") ? (value.contains(".") ? new JsonPrimitive((Number)Double.parseDouble(value)) : new JsonPrimitive((Number)Integer.parseInt(value))) : new JsonPrimitive(value));
                        if (current != null && current.equals(newVal)) continue;
                        json.add(key, (JsonElement)newVal);
                        System.out.println("[OK] Editado '" + key + "' en " + config.file);
                        modified = true;
                    }
                    if (modified) {
                        FileWriter writer = new FileWriter(configFile);
                        try {
                            gson.toJson((JsonElement)json, (Appendable)writer);
                            continue;
                        }
                        finally {
                            ((Writer)writer).close();
                            continue;
                        }
                    }
                    System.out.println("[SKIP] Sin cambios: " + config.file);
                }
                catch (JsonSyntaxException | IOException throwable) {
                    System.err.println("[ERROR] Error al modificar JSON " + config.file + ": " + throwable.getMessage());
                }
                continue;
            }
            try {
                List<String> list = Files.readAllLines(configFile.toPath());
                boolean modified = false;
                ArrayList<Object> newLines = new ArrayList<Object>();
                for (String string : list) {
                    String trimmed = string.trim();
                    boolean lineModified = false;
                    for (Map.Entry<String, String> entry : config.replacements.entrySet()) {
                        String key = entry.getKey();
                        String expectedValue = entry.getValue();
                        String regex = "^(\\s*[\"']?" + Pattern.quote(key) + "[\"']?\\s*[:=]\\s*)(['\"]?)(.*?)(['\"]?)([;]?)\\s*$";
                        Pattern pattern = Pattern.compile(regex);
                        Matcher matcher = pattern.matcher(string);
                        if (!matcher.find()) continue;
                        String currentValue = matcher.group(3).replaceAll("^[\"']+", "").replaceAll("[\"']+$", "").replaceAll(";$", "").trim();
                        if (!currentValue.equals(expectedValue.trim())) {
                            String replacement = matcher.group(1) + matcher.group(2) + expectedValue + matcher.group(4) + matcher.group(5);
                            newLines.add(replacement);
                            modified = true;
                            lineModified = true;
                            System.out.println("[OK] Editado '" + key + "' en " + config.file);
                            break;
                        }
                        System.out.println("[SKIP] No se necesita editar '" + key + "' en " + config.file);
                        break;
                    }
                    if (lineModified) continue;
                    newLines.add(string);
                }
                if (modified) {
                    Files.write(configFile.toPath(), newLines, new OpenOption[0]);
                    continue;
                }
                System.out.println("[OK] Sin cambios: " + config.file);
            }
            catch (IOException iOException) {
                System.err.println("[ERROR] Error procesando " + config.file + ": " + iOException.getMessage());
            }
        }
        System.out.println("=== SABICORP ModsUpdater Finalizado ===");
    }

    private static String getModpackIdFromArgs(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("--modpackid=")) continue;
            return arg.substring("--modpackid=".length());
        }
        return null;
    }

    private static String getEnvFromArgs(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("--env=")) continue;
            return arg.substring("--env=".length());
        }
        return null;
    }

    static class ModpackDefinition {
        SelfUpdater selfUpdater;
        List<ModInfo> mods;
        List<ConfigEdit> config;

        ModpackDefinition() {
        }
    }

    static class SelfUpdater {
        String target;
        String url;

        SelfUpdater() {
        }
    }

    static class ModInfo {
        String name;
        String pattern;
        String url;
        String target;

        ModInfo() {
        }
    }

    static class ConfigEdit {
        String file;
        Map<String, String> replacements;

        ConfigEdit() {
        }
    }
}

