/*
 * Decompiled with CFR 0.152.
 */
package net.sabicorp.modsupdater;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModsUpdater {
    private static final String API_BASE = "https://mcupdater.sabicorp.net/";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void main(String[] args) {
        ModpackDefinition modpack;
        String env;
        File modsDir;
        String instMcDir;
        System.out.println("=== SABICORP ModsUpdater ===");
        String modpackId = ModsUpdater.getModpackIdFromArgs(args);
        if (modpackId == null) {
            System.err.println("[ERROR] No se ha proporcionado --modpackid=...");
            System.exit(1);
        }
        if ((instMcDir = System.getenv("INST_MC_DIR")) == null || instMcDir.isEmpty()) {
            System.err.println("[ERROR] No se ha definido la variable de entorno INST_MC_DIR.");
            System.exit(1);
        }
        if (!(modsDir = new File(instMcDir, "mods")).exists()) {
            System.err.println("[ERROR] La carpeta de mods no existe: " + modsDir.getAbsolutePath());
            System.exit(1);
        }
        String jsonFilename = ((env = ModsUpdater.getEnvFromArgs(args)) != null ? env : "latest") + ".json";
        String jsonUrl = API_BASE + modpackId + "/" + jsonFilename;
        System.out.println("[DOWNLOAD] Cargando datos desde: " + jsonUrl);
        try (InputStream in = new URL(jsonUrl).openStream();){
            modpack = gson.fromJson((Reader)new InputStreamReader(in), ModpackDefinition.class);
        }
        catch (IOException e) {
            System.err.println("[ERROR] No se pudo descargar la definici\u00f3n del modpack: " + e.getMessage());
            return;
        }
        List<ModInfo> mods = modpack.mods;
        List<ConfigEdit> configEdits = modpack.config;
        System.out.println("--- Comprobando mods instalados ---");
        for (ModInfo mod : mods) {
            Pattern pattern = Pattern.compile(mod.pattern);
            File targetFile = new File(modsDir, mod.target);
            if (targetFile.exists()) {
                System.out.println("[SKIP] Ya actualizado: " + mod.target);
                continue;
            }
            for (File file : Objects.requireNonNull(modsDir.listFiles())) {
                if (!pattern.matcher(file.getName()).matches() || file.getName().equals(mod.target)) continue;
                System.out.println("[DELETE] Eliminando: " + file.getName());
                file.delete();
            }
            System.out.println("[DOWNLOAD] Descargando " + mod.name + " desde " + mod.url);
            try {
                InputStream in = new URL(mod.url).openStream();
                try {
                    Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("[OK] Mod actualizado: " + mod.target);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                System.err.println("[ERROR] Error descargando " + mod.name + ": " + e.getMessage());
            }
        }
        System.out.println("--- Comprobando configuraci\u00f3n ---");
        for (ConfigEdit config : configEdits) {
            String key;
            File configFile = new File(instMcDir, config.file);
            if (!configFile.exists()) {
                System.out.println("[SKIP] Archivo no encontrado, se ignora: " + config.file);
                continue;
            }
            if (configFile.getName().toLowerCase().endsWith(".json")) {
                try (FileReader reader = new FileReader(configFile);){
                    JsonObject json = gson.fromJson((Reader)reader, JsonObject.class);
                    boolean modified = false;
                    for (Map.Entry entry : config.replacements.entrySet()) {
                        key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        JsonElement current = json.get(key);
                        JsonPrimitive newVal = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") ? new JsonPrimitive(Boolean.parseBoolean(value)) : (value.matches("-?\\d+(\\.\\d+)?") ? (value.contains(".") ? new JsonPrimitive(Double.parseDouble(value)) : new JsonPrimitive(Integer.parseInt(value))) : new JsonPrimitive(value));
                        if (current != null && current.equals(newVal)) continue;
                        json.add(key, newVal);
                        System.out.println("[OK] Editado '" + key + "' en " + config.file);
                        modified = true;
                    }
                    if (modified) {
                        FileWriter writer = new FileWriter(configFile);
                        try {
                            gson.toJson((JsonElement)json, (Appendable)writer);
                            continue;
                        }
                        finally {
                            ((Writer)writer).close();
                            continue;
                        }
                    }
                    System.out.println("[SKIP] Sin cambios: " + config.file);
                }
                catch (JsonSyntaxException | IOException e) {
                    System.err.println("[ERROR] Error al modificar JSON " + config.file + ": " + e.getMessage());
                }
                continue;
            }
            try {
                List<String> lines;
                if (configFile.getName().equalsIgnoreCase("options.txt")) {
                    try {
                        lines = Files.readAllLines(configFile.toPath());
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        boolean modified = false;
                        for (String string : lines) {
                            String[] parts = string.split(":", 2);
                            if (parts.length != 2) continue;
                            map.put(parts[0], parts[1]);
                        }
                        for (Map.Entry entry : config.replacements.entrySet()) {
                            key = (String)entry.getKey();
                            String newValue = (String)entry.getValue();
                            if (!map.containsKey(key)) {
                                System.out.println("[ADD] Clave nueva a\u00f1adida: '" + key + "' en " + config.file);
                                map.put(key, newValue);
                                modified = true;
                                continue;
                            }
                            if (!((String)map.get(key)).equals(newValue)) {
                                System.out.println("[OK] Editado '" + key + "' en " + config.file);
                                map.put(key, newValue);
                                modified = true;
                                continue;
                            }
                            System.out.println("[SKIP] No se necesita editar '" + key + "' en " + config.file);
                        }
                        if (modified) {
                            ArrayList<CallSite> output = new ArrayList<CallSite>();
                            for (Map.Entry entry2 : map.entrySet()) {
                                output.add((CallSite)((Object)((String)entry2.getKey() + ":" + (String)entry2.getValue())));
                            }
                            Files.write(configFile.toPath(), output, new OpenOption[0]);
                            continue;
                        }
                        System.out.println("[OK] Sin cambios: " + config.file);
                    }
                    catch (IOException e) {
                        System.err.println("[ERROR] Error procesando options.txt: " + e.getMessage());
                    }
                    continue;
                }
                lines = Files.readAllLines(configFile.toPath());
                boolean modified = false;
                ArrayList<Object> newLines = new ArrayList<Object>();
                for (String string : lines) {
                    String trimmed = string.trim();
                    boolean lineModified = false;
                    for (Map.Entry<String, String> entry : config.replacements.entrySet()) {
                        String key2 = entry.getKey();
                        String expectedValue = entry.getValue();
                        String regex = "^(\\s*[\"']?" + Pattern.quote(key2) + "[\"']?\\s*[:=]\\s*)(['\"]?)(.*?)(['\"]?)([;]?)\\s*$";
                        Pattern pattern = Pattern.compile(regex);
                        Matcher matcher = pattern.matcher(string);
                        if (!matcher.find()) continue;
                        String currentValue = matcher.group(3).replaceAll("^[\"']+", "").replaceAll("[\"']+$", "").replaceAll(";$", "").trim();
                        if (!currentValue.equals(expectedValue.trim())) {
                            String replacement = matcher.group(1) + matcher.group(2) + expectedValue + matcher.group(4) + matcher.group(5);
                            newLines.add(replacement);
                            modified = true;
                            lineModified = true;
                            System.out.println("[OK] Editado '" + key2 + "' en " + config.file);
                            break;
                        }
                        System.out.println("[SKIP] No se necesita editar '" + key2 + "' en " + config.file);
                        break;
                    }
                    if (lineModified) continue;
                    newLines.add(string);
                }
                if (modified) {
                    Files.write(configFile.toPath(), newLines, new OpenOption[0]);
                    continue;
                }
                System.out.println("[SKIP] Sin cambios: " + config.file);
            }
            catch (IOException e) {
                System.err.println("[ERROR] Error procesando " + config.file + ": " + e.getMessage());
            }
        }
        System.out.println("--- Comprobando archivos ---");
        if (modpack.files != null) {
            for (RemoteFile file : modpack.files) {
                File destination = new File(instMcDir, file.target);
                File parentDir = destination.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    System.err.println("[ERROR] No se pudo crear la carpeta destino: " + parentDir.getAbsolutePath());
                    continue;
                }
                System.out.println("[DOWNLOAD] " + file.url + " \u2192 " + file.target);
                try (InputStream in = new URL(file.url).openStream();){
                    Files.copy(in, destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("[OK] Archivo descargado: " + file.target);
                }
                catch (IOException e) {
                    System.err.println("[ERROR] No se pudo descargar el archivo: " + file.url + " - " + e.getMessage());
                }
            }
        }
        System.out.println("=== SABICORP ModsUpdater Finalizado ===");
    }

    private static String getModpackIdFromArgs(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("--modpackid=")) continue;
            return arg.substring("--modpackid=".length());
        }
        return null;
    }

    private static String getEnvFromArgs(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("--env=")) continue;
            return arg.substring("--env=".length());
        }
        return null;
    }

    static class ModpackDefinition {
        List<ModInfo> mods;
        List<ConfigEdit> config;
        List<RemoteFile> files;

        ModpackDefinition() {
        }
    }

    static class ModInfo {
        String name;
        String pattern;
        String url;
        String target;

        ModInfo() {
        }
    }

    static class ConfigEdit {
        String file;
        Map<String, String> replacements;

        ConfigEdit() {
        }
    }

    static class RemoteFile {
        String url;
        String target;

        RemoteFile() {
        }
    }
}

